 ; Ŀ
 ;   Jumper - install a jumper, break around existing wires.               
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;   Chips are made from silicon?  This must be another stone age.         
 ; 

 ; Ŀ
 ;   Git - get an ss containing a line and anything crossing it.           
 ; 
 (DEFUN GIT (lasst / entt p10 p11 angg mid dscal mid1 mid2 dist ss)
  (setq entt (entget lasst))
  (setq p10 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq angg (angle p10 p11))
  (setq mid (polar p10 angg (/ (setq dist (distance p10 p11)) 2)))
  (setq dscal (misps))
  (setq mid1 (polar mid (+ angg (/ pi 2)) (* dscal 0.1)))
  (setq mid2 (polar mid (+ angg (* pi 1.5)) (* dscal 0.1)))
  (if (< 1 dist)
      (progn
           (setq p10 (polar p10 angg 0.5))
           (setq p11 (polar p11 (+ angg pi) 0.5))))
  (setq ss (ssget "cp" (list p10 mid1 p11 mid2)))
 ss)
 ; Ŀ
 ;   Git end.                                                              
 ; 


 ; Ŀ
 ;   IV - subroutine - decide which way to cut the lines.                  
 ; 
 (DEFUN IV (/ ang)
  (setq ang (/ pi 2))
;  (setq ang (getangle (cadr (grread t)) "\nBreak direction: "))
  (if (> ang pi) (setq ang (- ang pi)))
  (if (and (> ang (/ pi 4)) (< ang (* pi 0.75)))
      (setq orient "Vertical")
      (setq orient "Horizontal"))
 (princ))
 ; Ŀ
 ;   IV end.                                                               
 ; 

 ; Ŀ
 ;   Wingo - subroutine - take two lines and their intersection as         
 ;   arguments, cuts one and adds any resulting new entities to the ss.    
 ;   Don't forget to update the data on the line which was cut before ret. 
 ; 
 (DEFUN WINGO (lin1 lin2 intrs chdist / last ang1 ang2 enampt ptx pty cut1
                                                                 cut2 nulast)
  (setq last (entlast))
 ; Ŀ
 ;   First decide which line to cut.  Get the two angles.                  
 ; 
  (setq ang1 (angle (cdr (assoc 10 (entget lin1)))
                    (cdr (assoc 11 (entget lin1)))))
  (setq ang2 (angle (cdr (assoc 10 (entget lin2)))
                    (cdr (assoc 11 (entget lin2)))))
 ; Ŀ
 ;   Reduce both angles to <= 180.                                        
 ; 
  (if (< pi ang1) (setq ang1 (- ang1 pi)))
  (if (< pi ang2) (setq ang2 (- ang2 pi)))
 ; Ŀ
 ;   Determine which line to cut.                                          
 ;   The cut distance is angled so that the vertical or horizontal         
 ;   component is equal to the break distance.                             
 ;   If the vertical line is to be cut:                                    
 ; 
  (if (= orient "Vertical")
      (progn
           (if (< (abs (- (/ pi 2) ang1))            ; if ang1 is closer to 90
                  (abs (- (/ pi 2) ang2)))           ; than ang2
               (progn
                    (setq enampt (list lin1 intrs))  ; then break line 1
                    (setq ang ang1))                 ; and use angle1
               (progn
                    (setq enampt (list lin2 intrs))  ; otherwise break line 2
                    (setq ang ang2)))                ; and use angle2
           (setq hyp (/ chdist (cos (abs (- (/ pi 2) ang)))))) ; cut distance
 ; Ŀ
 ;   If the horizontal line is to be cut:                                  
 ; 
      (progn
           (if (> (abs (- (/ pi 2) ang1))            ; if ang1 is closer to 90
                  (abs (- (/ pi 2) ang2)))           ; than ang2
               (progn
                    (setq enampt (list lin1 intrs))  ; then break line 1
                    (setq ang ang1))                 ; and use angle1
               (progn
                    (setq enampt (list lin2 intrs))  ; otherwise break line 2
                    (setq ang ang2)))                ; and use angle2
           (setq hyp (/ chdist (sin (abs (- (/ pi 2) ang))))))) ; cut distance
 ; Ŀ
 ;   Now cut the line.                                                     
 ; 
  (setq cut1 (polar intrs ang hyp))
  (setq cut2 (polar intrs ang (- hyp)))
  (command "break" enampt "f" cut1 cut2)           ; break the line
 ; Ŀ
 ;   As each line is broken see if a new entity was created and if so      
 ;   (if not the previous entlast) add it to the ss.                       
 ; 
  (setq nulast (entlast))
  (if (/= nulast last)
      (ssadd nulast ss))
 (princ))
 ; Ŀ
 ;   Xingo end.                                                            
 ; 

 ; Ŀ
 ;   Wing - the chainsaw.                                                  
 ; 
 (DEFUN WING (ss / blip oz s t1 ss str chds num enam pos1 lll lln a1 b2
                                                           rat ra c3 d4 xx t2)
  (setq chdist (* (misps) 1))
 ; Ŀ
 ;   Now remove anything from the ss which isn't a line.                   
 ; 
  (setq num 0)                            ; ss position counter
  (while (and ss (setq enam (ssname ss num)))
         (if (= (cdr (assoc 0 (entget enam))) "LINE")
             (setq num (1+ num))
             (ssdel enam ss)))
 ; Ŀ
 ;   If there are any lines left in the ss, ask for a break direction      
 ;   which is saved in the global variable Orient.                         
 ; 
  (if (and ss (/= (sslength ss) 0)) (iv))
 ; Ŀ
 ;   Now see if each line in the ss intersects any of the others.  If      
 ;   it does then add the intersection to the breakpoint list.             
 ;   Start with the first (index 0) line and check each one against all    
 ;   those after it for intersections.                                     
 ;   If any are found then call Xingo to break them.                       
 ; 
  (setvar "blipmode" 0)
  (setq pos1 0)                                    ; current entity position
  (while (and ss (setq lll (ssname ss pos1)))      ; while entity #1 exists
         (setq num (1+ pos1))                      ; 2nd ent pos
         (setq lll (ssname ss pos1))               ; 1st entity name
         (setq lln (entget lll))                   ; the whole thing
         (setq a1 (cdr (assoc 10 lln)))            ; its start
         (setq b2 (cdr (assoc 11 lln)))            ; its end
         (while (setq rat (ssname ss num))         ; while next entity exists
                (setq ra (entget rat))             ; its name
                (setq c3 (cdr (assoc 10 ra)))      ; its start
                (setq d4 (cdr (assoc 11 ra)))      ; its end
                (if (and a1 b2 c3 d4)
                    (setq xx (inters a1 b2 c3 d4)) ; see if it intersects 1st
                    (setq xx ()))
                (if (and xx                        ; if it does
                        (not (or (equal xx a1)     ; and it's not a line end
                                 (equal xx b2)
                                 (equal xx c3)
                                 (equal xx d4))))
                    (progn
 ; Ŀ
 ;   The two current lines crossed: call subroutine Xingo to break the     
 ;   correct line and add any new entities to ss.  Also re-entget lll,     
 ;   the line against which the others are being checked, in case it has   
 ;   changed (had one end chopped off).                                    
 ; 
                         (wingo lll rat xx chdist) ; and break the line.
                         (setq lln (entget lll))   ; reacquire master line data
                         (setq a1 (cdr (assoc 10 lln)))    ; start
                         (setq b2 (cdr (assoc 11 lln)))))  ; and end
                (setq num (1+ num)))               ; go to next entity
         (setq pos1 (1+ pos1)))                    ; next master check entity

 (princ))
 ; Ŀ
 ;   Wing end.                                                             
 ; 

 ; Ŀ
 ;   Jumper - the jumper.                                                  
 ; 
 (DEFUN C:JUMPER (/ chdist pa orth ps hdist hang vang pa1 pb1 blip oz ss)

  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq chdist 1)                             ; break halfwidth
  (if (= (type pb) 'LIST)
      (progn
           (setq pa (getpoint pb "First point (or <Return> for previous): "))
           (if (null pa) (setq pa pb)))
      (setq pa (getpoint "First point: ")))
  (setq pb (getpoint pa "\nOther end: "))
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
  (setq ps (getpoint pa "\nApproximate location: "))
 ; Ŀ
 ;   Set the horizontal distance Hdist to the nearest multiple of 2.5.     
 ;   (The vertical distance is always 2.5.)                                
 ; 
  (setq hdist (abs (- (car pa) (car ps))))   ; horizontal rather than diagonal
  (setq hdist (* 2.5 (fix (/ (+ hdist 1.25) 2.5))))
  (setvar "orthomode" orth)
  (if (> (car ps) (car pa))
      (setq hang 0)              ; right side of tb
      (setq hang pi))            ; left side
  (if (> (cadr pb) (cadr pa))
      (setq vang (* pi 0.5))     ; pb is above pa
      (setq vang (* pi 1.5)))    ; pb is below
  (setq pa1 (polar (polar pa hang hdist) vang 2.5))
  (setq pb1 (polar (polar pb hang hdist) (+ pi vang) 2.5))
  (setq blip (getvar "blipmode"))           ; save blipmode
  (setq oz (getvar "osmode"))               ; save osnapmode
  (setvar "osmode" 0)                       ; so osnaps won't alter point picks
  (setvar "blipmode" 0)                     ; turn blips off
  (command "line" pa pa1 "")
  (setq ss (git (entlast)))
  (wing ss)
  (command "line" pa1 pb1 "")
  (setq ss (git (entlast)))
  (wing ss)
  (command "line" pb1 pb "")
  (setq ss (git (entlast)))
  (wing ss)
  (setvar "osmode" oz)                      ; reinstate osnapmode
  (setvar "blipmode" blip)
 (princ))